<div class="min-h-[calc(100vh-152px)]">
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty) :
        WSErro("Ops: Você tentou editar um produto que não existe no sistema!", WS_INFOR);
    endif;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action) :
        require('_models/Produtos.class.php');

        $postAction = filter_input(INPUT_GET, 'produtoid', FILTER_VALIDATE_INT);
        $postUpdate = new Produtos;

        switch ($action):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Produtos cadastrados</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Categoria</th>
                            <th>Valor</th>
                            <th>Estoque</th>
                            <th class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $produtos = new Read;
                        $produtos->ExeRead(DB_PRODUTOS, " ORDER BY id_categoria ASC");
                        foreach ($produtos->getResult() as $produto) :
                            extract($produto);

                            $vendas = new Read;
                            $vendas->FullRead("SELECT SUM(qtd) AS qt FROM " . DB_CARRINHO . " WHERE cod = {$cod}");
                            $qt = $vendas->getResult()[0]["qt"];

                            $entradas = new Read;
                            $entradas->FullRead("SELECT SUM(entry_qt) AS qt FROM " . DB_ENTRADAS . " WHERE entry_pdt = {$cod}");

                            if ($entradas->getResult()) :
                                $entrada = $entradas->getResult()[0]["qt"];
                                $final =  $entrada + ($estoque_atual - $qt);

                                if ($final <= $estoque_minimo) :
                                    $cor = "#FFF7D4";
                                else :
                                    $cor = "white";
                                endif;
                            else :

                                if ($final <= $estoque_minimo) :
                                    $cor = "#FFF7D4";
                                else :
                                    $cor = "white";
                                endif;
                                $final = ($estoque_atual - $qt);
                            endif;
                        ?>
                            <tr style="background-color: <?= $cor; ?> !important;">
                                <td class="whitespace-nowrap"><?= $nome; ?></td>
                                <td>
                                    <?php
                                    $categorias = new Read;
                                    $categorias->FullRead("SELECT * FROM " . DB_CATEGORIAS . " WHERE id_categoria = {$id_categoria}");
                                    $cat = $categorias->getResult()[0]['nome'];
                                    echo $cat;
                                    ?>
                                </td>
                                <td><?= number_format($preco, 2, ',', '.'); ?></td>
                                <td><?= $final; ?></td>
                                <td class="text-center"><a href="painel.php?exe=produtos/entrada&produtoid=<?= $cod; ?>">Lançar estoque</a> | <a href="painel.php?exe=produtos/update&produtoid=<?= $cod; ?>">Editar</a> | <a href="painel.php?exe=produtos/index&produtoid=<?= $cod; ?>&action=delete">Excluir</a></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>