<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        require('_models/Produtos.class.php');
        $cadastra = new Produtos;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()) :
            header('Location: painel.php?exe=produtos/update&create=true&produtoid=' . $cadastra->getResult());
        else :
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Produto</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Cadastrar produto</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Produto</label>
                        <input type="text" class="form-input" name="nome" placeholder="Informe o nome do produto" value="<?php if (isset($post['nome'])) echo $post['nome']; ?>" autofocus>
                    </div>
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Categoria</label>
                        <select name="id_categoria" class="form-select">
                            <option value="">Selecione</option>
                            <?php
                            $categorias = new Read;
                            $categorias->ExeRead(DB_CATEGORIAS, " ORDER BY nome ASC");
                            foreach ($categorias->getResult() as $categoria) :
                                extract($categoria);
                            ?>
                                <option value="<?= $id_categoria; ?>"><?= $nome; ?></option>
                            <?php
                            endforeach;
                            ?>
                        </select>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Valor</label>
                        <input type="text" class="form-input" name="preco" placeholder="Informe o valor" value="<?php if (isset($post['preco'])) echo $post['preco']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Preparado na cozinha?</label>
                        <select name="destino" class="form-select">
                            <option value="">Selecione</option>
                            <option value="1">Sim</option>
                            <option value="0">Não</option>
                        </select>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque atual</label>
                        <input type="text" class="form-input" name="estoque_atual" placeholder="Informe o estoque atual" value="<?php if (isset($post['estoque_atual'])) echo $post['estoque_atual']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque mínimo</label>
                        <input type="text" class="form-input" name="estoque_minimo" placeholder="Informe o estoque mínimo para receber um alerta" value="<?php if (isset($post['estoque_minimo'])) echo $post['estoque_minimo']; ?>">
                    </div>

                </div>
                <div>
                    <br />
                    <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>