<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $postid = filter_input(INPUT_GET, 'produtoid', FILTER_VALIDATE_INT);

    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        require('_models/Produtos.class.php');
        $cadastra = new Produtos;
        $cadastra->ExeUpdate($postid, $post);

        WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
    else :
        $read = new Read;
        $read->ExeRead(DB_PRODUTOS, "WHERE cod = :id", "id={$postid}");
        if (!$read->getResult()) :
            header('Location: painel.php?exe=produtos/index&empty=true');
        else :
            $post = $read->getResult()[0];
        endif;
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("O produto foi cadastrado com sucesso no sistema! <a href='https://espetinhobatepapo.edgarmagalhaes.com/painel.php?exe=produtos/create'>cadastrar novo</a>", WS_ACCEPT);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Produto</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Cadastrar produto</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Produto</label>
                        <input type="text" class="form-input" name="nome" placeholder="Informe o nome do produto" value="<?php if (isset($post['nome'])) echo $post['nome']; ?>">
                    </div>
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Categoria</label>
                        <select name="id_categoria" class="form-select">
                            <option value="">Selecione</option>
                            <?php
                            $categorias = new Read;
                            $categorias->ExeRead(DB_CATEGORIAS, " ORDER BY nome ASC");
                            foreach ($categorias->getResult() as $categoria) :
                                extract($categoria);

                                if ($id_categoria == $post['id_categoria']) :

                            ?>
                                    <option value="<?= $id_categoria; ?>" selected><?= $nome; ?></option>
                                <?php
                                else :
                                ?>
                                    <option value="<?= $id_categoria; ?>"><?= $nome; ?></option>
                            <?php
                                endif;
                            endforeach;
                            ?>
                        </select>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Valor</label>
                        <input type="text" class="form-input" name="preco" placeholder="Informe o valor" value="<?php if (isset($post['preco'])) echo $post['preco']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Preparado na cozinha?</label>
                        <select name="destino" class="form-select">
                            <option value="">Selecione</option>
                            <option value="1" <?php if (isset($post['destino']) && $post['destino'] == 1) echo 'selected="selected"'; ?>>Sim</option>
                            <option value="0" <?php if (isset($post['destino']) && $post['destino'] == 0) echo 'selected="selected"'; ?>>Não</option>
                        </select>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque atual</label>
                        <input type="text" class="form-input" name="estoque_atual" placeholder="Informe o estoque atual" value="<?php if (isset($post['estoque_atual'])) echo $post['estoque_atual']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque mínimo</label>
                        <input type="text" class="form-input" name="estoque_minimo" placeholder="Informe o estoque mínimo para receber um alerta" value="<?php if (isset($post['estoque_minimo'])) echo $post['estoque_minimo']; ?>">
                    </div>

                </div>
                <div>
                    <br />
                    <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Atualizar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>